//
//  HNSSyntaxAwareTextView.h
//  CocoaBasic
//
//  Created by Dr. H. Nikolaus Schaller on Fri Jun 21 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>

// @interface NSText (SyntaxHighlight)
@interface HNSSyntaxAwareTextView : NSTextView
{
	NSDictionary *keywords;
//	NSCharacterSet *symbolical;
}

- (void) setKeywordDictionary:(NSDictionary *) dict;	// set dictionary
#define Keywords_KEYWORDS @"Keywords"
#define Keywords_SYMBOLICAL @"SymbolCharacters"
#define Keywords_MOREINDENT @"MoreIndent"
#define Keywords_LESSINDENT @"LessIndent"
#define Keywords_TEMPLATE @"Template"
- (void) setKeywordResourceFile:(NSString *) path;
- (NSDictionary *) keywordDictionary;

- (void) highlightSyntax;			// highlight now
- (void) autoHighlight:(BOOL) flag;	// automatically highlight after all changes

- (IBAction) commentLines:(id) Sender; 
- (IBAction) insertTemplate:(id) Sender; 
- (IBAction) findnext:(id) Sender; 
- (IBAction) findprev:(id) Sender; 
- (IBAction) findsel:(id) Sender; 
- (IBAction) scrollSelection:(id) Sender; 

@end